using System;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Diagnostics;

namespace gov.va.med.vbecs.GUI
{

	/// <newpara> Package: VBECS - VistA Blood Establishment Computer System</newpara>
	/// <newpara> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</newpara>
	/// <newpara> Medical Device #: $MEDDEVICENO</newpara>
	/// <newpara> Date Created: 4/30/2002</newpara>
	/// <newpara> Site Name: Hines OIFO </newpara>
	/// <newpara> Developers: Cameron Taylor, John Vrooland</newpara>
	/// <summary> Description: GUI Splash Screen class</summary>
	/// <newpara> Note: The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</newpara>
	public class FrmSplash : System.Windows.Forms.Form
	{
		private System.Windows.Forms.PictureBox pictureBox1;
		private System.Windows.Forms.Timer timer1;
		private System.ComponentModel.IContainer components;

		/// <newpara> Function Name: FrmSplash</newpara>
		/// <newpara> Developers: Cameron Taylor, John Vrooland</newpara>
		/// <newpara> Site Name: Hines OIFO </newpara>
		/// <newpara> Date Created: 4/30/2002</newpara>
		/// <summary> Description: FrmSplash class constructor. Uses Double buffering</summary>
		/// <returns>N/A</returns>
		public FrmSplash()
		{
			InitializeComponent();
			/*
			 *  Double Buffering
			 */
			SetStyle(ControlStyles.UserPaint, true);
			SetStyle(ControlStyles.AllPaintingInWmPaint, true);
			SetStyle(ControlStyles.DoubleBuffer, true);
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(FrmSplash));
			this.pictureBox1 = new System.Windows.Forms.PictureBox();
			this.timer1 = new System.Windows.Forms.Timer(this.components);
			this.SuspendLayout();
			// 
			// pictureBox1
			// 
			this.pictureBox1.BackColor = System.Drawing.SystemColors.ControlDark;
			this.pictureBox1.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox1.Image")));
			this.pictureBox1.Location = new System.Drawing.Point(0, 0);
			this.pictureBox1.Name = "pictureBox1";
			this.pictureBox1.Size = new System.Drawing.Size(400, 300);
			this.pictureBox1.TabIndex = 0;
			this.pictureBox1.TabStop = false;
			this.pictureBox1.Paint += new System.Windows.Forms.PaintEventHandler(this.pictureBox1_Paint);
			// 
			// timer1
			// 
			this.timer1.Interval = 2000;
			this.timer1.Tick += new System.EventHandler(this.timer1_Tick);
			// 
			// FrmSplash
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.BackColor = System.Drawing.SystemColors.ControlDark;
			this.ClientSize = new System.Drawing.Size(400, 300);
			this.ControlBox = false;
			this.Controls.Add(this.pictureBox1);
			this.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.None;
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.Name = "FrmSplash";
			this.ShowInTaskbar = false;
			this.SizeGripStyle = System.Windows.Forms.SizeGripStyle.Hide;
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;
			this.TopMost = true;
			this.TransparencyKey = System.Drawing.SystemColors.ControlDark;
			this.Load += new System.EventHandler(this.FrmSplash_Load);
			this.ResumeLayout(false);

		}
		#endregion

		#region Methods

		/// <newpara> Function Name: MakeRoundRect</newpara>
		/// <newpara> Developers: John Vrooland</newpara>
		/// <newpara> Site Name: Hines OIFO </newpara>
		/// <newpara> Date Created: 4/30/2002</newpara>
		/// <summary> Description: Returns graphicspath of a round rectangle given original size</summary>>
		/// <param name="topLeft">Point</param>
		/// <param name="bottomRight">Point</param>
		/// <param name="percentageRounded">Int</param>
		/// <returns>GraphicsPath</returns>
		private GraphicsPath MakeRoundRect(Point topLeft, Point bottomRight, int percentageRounded)
		{
			Debug.Assert (percentageRounded >= 1 && percentageRounded <= 100);

			int left  = Math.Min(topLeft.X, bottomRight.X);
			int right = Math.Max(topLeft.X, bottomRight.X);

			int top    = Math.Min(topLeft.Y, bottomRight.Y);
			int bottom = Math.Max(topLeft.Y, bottomRight.Y);

			int offsetX = (right-left)*percentageRounded/100; 
			int offsetY = (bottom-top)*percentageRounded/100;

			GraphicsPath pt = new GraphicsPath();
			GraphicsPath path = (GraphicsPath)pt.Clone();

			path.AddArc(right-offsetX, top, offsetX, offsetY, 270, 90);

			path.AddArc(right-offsetX, bottom-offsetY, offsetX, offsetY, 0, 90);

			path.AddArc(left, bottom - offsetY, offsetX, offsetY, 90, 90);

			path.AddArc(left, top, offsetX, offsetY, 180, 90);

			path.AddLine(left + offsetX, top, right - offsetX/2, top);

			return path;
		}

		#endregion

		#region Events

		/// <newpara> Function Name: timer1_Tick</newpara>
		/// <newpara> Developers: Cameron Taylor</newpara>
		/// <newpara> Site Name: Hines OIFO </newpara>
		/// <newpara> Date Created: 4/30/2002</newpara>
		/// <summary> Description: Timer Tick event. Closes splash screen</summary>
		/// <param name="sender">Object</param>
		/// <param name="e">EventArgs</param>
		/// <returns>N/A</returns>
		private void timer1_Tick(object sender, System.EventArgs e)
		{
			this.Close();
		}

		/// <newpara> Function Name: FrmSplash_Load</newpara>
		/// <newpara> Developers: Cameron Taylor</newpara>
		/// <newpara> Site Name: Hines OIFO </newpara>
		/// <newpara> Date Created: 4/30/2002</newpara>
		/// <summary> Description: FrmSplash form Load event. Starts timer.</summary>
		/// <param name="sender">Object</param>
		/// <param name="e">EventArgs</param>
		/// <returns>N/A</returns>
		private void FrmSplash_Load(object sender, System.EventArgs e)
		{
			this.timer1.Enabled = true;
		}

		/// <newpara> Function Name: pictureBox1_Paint</newpara>
		/// <newpara> Developers: John Vrooland</newpara>
		/// <newpara> Site Name: Hines OIFO </newpara>
		/// <newpara> Date Created: 4/30/2002</newpara>
		/// <summary> Description: picturebox Paint event. Calls MakeRoundRect to make region of picture box into round rectangle (since transparent property wasn't working on all machines)</summary>
		/// <param name="sender">Object</param>
		/// <param name="e">PaintEventArgs</param>
		/// <returns>N/A</returns>
		private void pictureBox1_Paint(object sender, System.Windows.Forms.PaintEventArgs e)
		{
			GraphicsPath gp = MakeRoundRect(new Point(0,0), new Point(this.pictureBox1.Image.Width,this.pictureBox1.Image.Height), 30);
            //Defect 227411
            using (Region myReg = new Region(gp))
            {
                this.Region = new Region(gp);
            }
		}


		/// <newpara> Function Name: pictureBox1_Click</newpara>
		/// <newpara> Developers: John Vrooland</newpara>
		/// <newpara> Site Name: Hines OIFO </newpara>
		/// <newpara> Date Created: 4/30/2002</newpara>
		/// <summary> Description: picturebox Click event. Closes form independent to timer event</summary>
		/// <param name="sender">Object</param>
		/// <param name="e">EventArgs</param>
		/// <returns>N/A</returns>
		private void pictureBox1_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		#endregion
	}
}
